par(mfrow = c(1,1))
library(imager)
library(matrixStats)
library(scales)
library(gtools)
library(inflection)
options(scipen = 999)

#inputDirectory = '/Users/gfivash/Dropbox/Greg/Work/PhD/Thesis Chapters/Chapter 3 - Sediment hummocks/Data/Oxygen/Oxygen experiment/Data/Experiments/Exp 1 Flat 10h2h/E1-flatone-2h vs 10h-0-100-jpg/'
#inputDirectory = '/Users/gfivash/Dropbox/Greg/Work/PhD/Thesis Chapters/Chapter 3 - Sediment hummocks/Data/Oxygen/Oxygen experiment/Data/Experiments/Exp 5 +1cm 10h2h/E5-hummock1cm-2h vs 10h-jpg/'
inputDirectory = '/Users/gfivash/Dropbox/Greg/Work/PhD/Thesis Chapters/Chapter 3 - Sediment hummocks/Data/Oxygen/Oxygen experiment/Data/Data-Yue-20180731/E6/E6-hollow1cm-2h vs 10h-jpg/'
setwd(inputDirectory)

# make a list for sorted images in the file folder
filelist = mixedsort(dir())

# define the sediment surface
sedimentSurfaceDepth.cm = 3.33 # cm

# time settings
starttime = as.POSIXct('2018-06-20 17:36:00')
interval = 120  # 2min=120s between adjacent two images

# plotDirectory = '/Users/gfivash/Desktop/'
# setwd(plotDirectory)
# tiff("Figure 6b.tif",
#      width = 7, height = 6, 
#      units = 'in', res = 300)

flatPhotoSeq = c(1163,  1166, 1167,1169,1171,1175,1185,1200)
hummockPhotoSeq = seq(564,664,10)
hollowPhotoSeq = seq(230, 265, length.out = 9)  #539
plot(c(1), xlim = c(0.0005,100),ylim = c(4,-2), log ='',
     type = 'n',
     xlab = 'Oxygen saturation (%)', ylab = 'Depth (cm)')
lines(x = c(0,100), y = c(0,0), lty = 2, lwd = 2, col = alpha('black',0.5))
text('Sediment surface', x = 20, y = -0.5, col = alpha('black',0.5))
title('Flat')
#title('Raised')
# title('Lowered')
rect(ybottom = 4, ytop = 3, xleft = 100, xright = 0, lty = 0, col = alpha('black',0.1))
text('Out of frame', x = 50, y = 3.5)

oxygenDeclineRate = vector(mode = 'numeric', length = length(filelist))
#for(i in 1:length(filelist)){

for(i in hollowPhotoSeq){
#for(i in flatPhotoSeq){
#for(i in hummockPhotoSeq){
#while(T){ 
  par(mfrow = c(1,1))
  #i = round(runif(n = 1, min = 1, max = length(filelist)))
  setwd(inputDirectory)
  filename = filelist[i]
  
  # load images, grayscale, crop, convert class from image to matrix
  p = load.image(filename)
  p.g = grayscale(p)
  p.g.c = as.cimg(p.g[205:660,120:710, 1, 1])
  m = as.matrix(p.g.c)
  m = m*100
  # par(mfrow = c(1, 2))
  # plot(p.g)
  # plot(p.g.c)
  
  # synchronize depth layers in cm and in pixel
  depth = seq(0,6.24, length.out = dim(m)[2]) - 4.33 # depth in "cm"
  
  # calculate the mean values and SE in columns
  se = colSds(m)/sqrt(dim(m)[1])
  oxygen.mean = colMeans(m)
  x = oxygen.mean
  interval = 5
  xMean = c()
  for(i_window in 1:length(x)){
    start = i_window
    end = start + interval
    
    xMean[i_window] = mean(x[start:end], na.rm = T)
  }
  
  #plot the oxygen concentration vs depth
  # setwd(outputDirectory)
  #par(mfrow = c(1,1))
  setwd(plotDirectory)
  filter = depth > -2
  # arrows(y0 = depth, y1 = depth, x0 = oxygen.mean + se, x1 = oxygen.mean - se,
  #        code = 3, angle = 90, length = 0.01)
  # points(depth[filter] ~ oxygen.mean[filter], ylim = c(0,1), 
  #        pch = 21,
  #        bg = alpha(grey(colMeans(m)/100),0.8), cex = 0.5)
  points(depth[filter] ~ oxygen.mean[filter], pch = '.')
  #lines(x = c(-0.5,1.5), y = c(sedimentSurfaceDepth.cm, sedimentSurfaceDepth.cm), lty = 2)
  #title(filename)
  
  #inflectionPoint = bese(depth, oxygen.mean, index = 1)$iplast
  inflectionPoint = bese(depth, xMean, index = 1)$iplast
  
  #filter = which.min(abs(depth - inflectionPoint))
  filter = which.min(abs(xMean - 50))
  points(depth[filter] ~ xMean[filter], cex = 2, pch = 21, bg = alpha('yellow',0.5))
  
  filter = (depth > inflectionPoint)# & (xMean > 10)
  #y = oxygen.mean[filter]
  y = oxygen.mean[filter]
  x = depth[filter] - min(depth[filter])
  #y = y[x < 0.4]
  #x = x[x <  0.4]

  #plot(y ~ x, log ='')
  c = 1.4
  m = nls(y ~ exp(a + b*x) + c, start = list(a = 3.8, b = -3.5))
  summary(m)
  a = summary(m)$coefficients[1]
  b = summary(m)$coefficients[2]
  xv = seq(0,3, length.out = 1000)
  yv = exp(a + b*xv) + c
  #lines(yv ~ xv)
  xv2 = xv + min(depth[filter])
  lineFilter = xv2 < max(depth) & yv < 50
  lines(xv2[lineFilter] ~ yv[lineFilter], col = alpha('yellow',0.5), lwd = 2)
  
  print(paste(i,'/',length(filelist),';',b, sep = ' '))
  oxygenDeclineRate[i] = b
}
text(y = 1.3, x = 20, 'time')
arrows(x0 = 15, x1 = 15, y0 = 1.5, y1 =  0.3, length = 0.1, lwd = 2)
text(y = 0.5, x = 55, expression(t[1]))
text(y = 0.2, x = 54, expression(t[2]))
# dev.off()








